package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.objects.GenericObject;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.widgets.FractionTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ModifierDialog extends GenericDialog {
	private static final long serialVersionUID = 916471573286595020L;

	protected JLabel fixedValueLbl;

	protected Modifier modifier;

	protected GenericObject parent;

	protected JLabel valueLbl;

	protected FractionTF valueTF;

	protected JLabel commentsLbl;

	protected JTextField commentsTF;

	protected JLabel levelInfoLbl;

	public ModifierDialog(Modifier mod, boolean isNew, GenericObject parent) {
		super(mod, isNew, false);
		modifier = mod;
		this.parent = parent;
		init();
		if (mod.getXMLID().equals("MODIFIER")) { // custom mod
			displayTF.requestFocus();
			displayTF.selectAll();
		}
		if (pointsLbl != null) {
			pointsLbl.setVisible(false);
		}
		if (pointsTF != null) {
			pointsTF.setVisible(false);
		}
		multiplierBtn.setVisible(false);
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 50;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(5, 5, 5, 5);
		gbc.gridy = 49;
		panel.add(commentsLbl, gbc);
		gbc.gridy = 50;
		panel.add(valueLbl, gbc);
		gbc.gridx = 1;
		gbc.gridy = 49;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		panel.add(commentsTF, gbc);
		gbc.gridy = 50;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		if (!modifier.isFixedValue()) {
			panel.add(valueTF, gbc);
		} else {
			panel.add(fixedValueLbl, gbc);
		}

		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 1;
		gbc.weighty = 1;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		gbc.gridx = 2;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridy = 70;
		panel.add(levelInfoLbl, gbc);

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		if (!modifier.isFixedValue()) {
		valueTF.addPropertyChangeListener(new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				modifier.setBaseCost(valueTF.getCurrent());
				updateValues();
			}
		});
		}
		commentsTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				modifier.setComments(commentsTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				modifier.setComments(commentsTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				modifier.setComments(commentsTF.getText());
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		levelInfoLbl = new JLabel(modifier.getLevelInfo());
		valueLbl = new JLabel("Value:");
		valueTF = new FractionTF(modifier.getTotalValue(), modifier
				.getMaxCost(), parent instanceof Maneuver ? 0 : modifier
				.getMinimumCost(), modifier.useMultiplier());
		fixedValueLbl = new JLabel(""
				+ modifier.getFraction(modifier.getTotalValue()));

		notesBtn.setVisible(false);
		deleteBtn.setVisible(false);
		addModifierBtn.setVisible(false);
		customAdderBtn.setVisible(false);
		activePointsLbl.setVisible(false);
		realCostLbl.setVisible(false);

		if ((modifier.getAvailableAdders().size() == 0)
				&& (modifier.getAvailableModifiers().size() == 0)) {
			extrasScroll.setVisible(false);
		}
		nameLbl.setVisible(false);
		nameTF.setVisible(false);
		commentsLbl = new JLabel("Comments:");
		commentsTF = new JTextField();
		commentsTF.setText(modifier.getComments());
	}

	@Override
	public void updateValues() {
		// "reset" the selected option....this is necessary to prevent oddities
		// in the edit process...
		modifier.setSelectedOption(modifier.getSelectedOption());
		levelInfoLbl.setText(modifier.getLevelInfo());

		if (valueTF.isShowing()) {
			valueTF.setCurrent(modifier.getBaseCost());
		}
		fixedValueLbl.setText(modifier.getFraction(modifier.getTotalValue()));
		super.updateValues();
		if (modifier.refreshAddersOnUpdate()) {
			// re-do layout on the adders....may be changes due to selected
			// option
			layoutExtrasPanel();
			modifier.setRefreshAddersOnUpdate(false);
		}
		addModifierBtn.setVisible(false);
		customAdderBtn.setVisible(false);

		if ((modifier.getAvailableAdders().size() == 0)
				&& (modifier.getAvailableModifiers().size() == 0)) {
			extrasScroll.setVisible(false);
		} else {
			extrasScroll.setVisible(true);
		}

	}
}